<?php
include 'config.php';

// Obtener la configuración del sitio
$query = "SELECT site_name, site_description, counter_code, favicon_url FROM settings WHERE id = 1";
$result = mysqli_query($conn, $query);
$settings = mysqli_fetch_assoc($result);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($settings['site_name']); ?></title>
    <?php if (!empty($settings['favicon_url'])): ?>
        <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($settings['favicon_url']); ?>">
        <link rel="shortcut icon" type="image/png" href="<?php echo htmlspecialchars($settings['favicon_url']); ?>">
    <?php endif; ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <?php if (!empty($settings['counter_code'])): ?>
        <?php echo $settings['counter_code']; ?>
    <?php endif; ?>
</head>
<body class="bg-light">
    <div class="container text-center py-5">
        <h1 class="display-4"><?php echo htmlspecialchars($settings['site_name']); ?></h1>
        <p class="lead"><?php echo htmlspecialchars($settings['site_description']); ?></p>
        <a href="admin/login.php" class="btn btn-primary">Acceder al Panel</a>
    </div>
</body>
</html>