<?php
session_start();
include '../config.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

// Configuración de paginación
$items_per_page = 20;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $items_per_page;

// Obtener total de videos para la paginación
$total_query = "SELECT COUNT(*) as total FROM videos";
$total_result = mysqli_query($conn, $total_query);
$total_videos = mysqli_fetch_assoc($total_result)['total'];
$total_pages = ceil($total_videos / $items_per_page);

// Modificamos la consulta para obtener correctamente el conteo de vistas con paginación
$query = "SELECT v.*, 
          (SELECT COUNT(*) FROM video_views WHERE video_id = v.id) as view_count
          FROM videos v 
          ORDER BY v.upload_date DESC
          LIMIT $offset, $items_per_page";
$result = mysqli_query($conn, $query);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Videos - Free and Simple Video Hosting</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
    :root {
        --primary-gradient: linear-gradient(135deg, #6e8efb, #a777e3);
        --secondary-gradient: linear-gradient(135deg, #a777e3, #6e8efb);
        --card-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        --transition: all 0.3s ease;
    }

    body {
        background-color: #f8f9fe;
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
    }

    .videos-header {
        background: var(--primary-gradient);
        padding: 2rem 0;
        margin-bottom: 2rem;
        color: white;
        border-radius: 0 0 25px 25px;
        box-shadow: var(--card-shadow);
    }

    .videos-card {
        background: white;
        border-radius: 20px;
        box-shadow: var(--card-shadow);
        overflow: hidden;
        margin-bottom: 2rem;
    }

    .table {
        margin-bottom: 0;
    }

    .table th {
        background: #f8f9fe;
        border: none;
        padding: 1rem;
        font-weight: 600;
        color: #2d3748;
    }

    .table td {
        padding: 1rem;
        vertical-align: middle;
        border-color: #f1f5f9;
    }

    .table tr:hover {
        background-color: #f8fafc;
    }

    .btn-action {
        padding: 0.5rem 1rem;
        border-radius: 10px;
        transition: var(--transition);
        font-size: 0.875rem;
    }

    .btn-action:hover {
        transform: translateY(-2px);
    }

    .btn-danger {
        background: #dc3545;
        border: none;
    }

    .btn-danger:hover {
        background: #bb2d3b;
        box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
    }

    .form-check-input {
        width: 1.2rem;
        height: 1.2rem;
        border-radius: 6px;
        cursor: pointer;
    }

    .form-check-input:checked {
        background-color: #6e8efb;
        border-color: #6e8efb;
    }

    .badge {
        padding: 0.5rem 0.75rem;
        border-radius: 8px;
        font-weight: 500;
    }

    .badge-info {
        background: rgba(110, 142, 251, 0.1);
        color: #6e8efb;
    }

    .copy-btn {
        border: 2px solid #e2e8f0;
        background: white;
        color: #6e8efb;
        transition: var(--transition);
    }

    .copy-btn:hover {
        background: #6e8efb;
        color: white;
        border-color: #6e8efb;
    }

    .pagination {
        margin-top: 1rem;
        margin-bottom: 1rem;
        justify-content: center;
    }

    .page-link {
        padding: 0.5rem 1rem;
        color: #6e8efb;
        border: none;
        margin: 0 0.25rem;
        border-radius: 8px;
        transition: var(--transition);
    }

    .page-link:hover {
        background: rgba(110, 142, 251, 0.1);
        color: #6e8efb;
    }

    .page-item.active .page-link {
        background: var(--primary-gradient);
        color: white;
    }

    .video-link {
        max-width: 300px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    .btn-group-actions {
        background: #f8f9fe;
        padding: 1rem;
        border-radius: 15px;
        margin-bottom: 1rem;
    }

    @media (max-width: 768px) {
        .video-link {
            max-width: 200px;
        }
    }
    </style>
</head>
<body>
    <?php include 'navbar.php'; ?>

    <div class="videos-header">
        <div class="container">
            <h1 class="mb-2">
                <i class="fas fa-film me-2"></i>Lista de Videos
            </h1>
            <p class="mb-0 opacity-75">Gestiona tu biblioteca de videos</p>
        </div>
    </div>

    <div class="container">
        <div class="btn-group-actions d-flex justify-content-between align-items-center">
            <div>
                <button id="selectAll" class="btn btn-action btn-outline-primary me-2">
                    <i class="fas fa-check-square me-1"></i>Seleccionar Todo
                </button>
                <button id="deleteSelected" class="btn btn-action btn-danger" disabled>
                    <i class="fas fa-trash me-1"></i>Eliminar Seleccionados
                </button>
            </div>
            <div class="text-muted">
                Total: <?php echo $total_videos; ?> videos
            </div>
        </div>
        
        <div class="videos-card">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="masterCheck">
                                </div>
                            </th>
                            <th>Nombre</th>
                            <th>URL</th>
                            <th>Vistas</th>
                            <th>Fecha Subida</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($video = mysqli_fetch_assoc($result)): ?>
                            <tr>
                                <td>
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input video-check" value="<?php echo $video['id']; ?>">
                                    </div>
                                </td>
                                <td><?php echo htmlspecialchars($video['original_name'] ?? $video['filename']); ?></td>
                                <td class="video-link">
                                    <div class="input-group">
                                        <input type="text" class="form-control" value="https://<?php echo $_SERVER['HTTP_HOST'] . '/' . $video['filename']; ?>" readonly>
                                        <button class="btn copy-btn" type="button">
                                            <i class="fas fa-copy"></i>
                                        </button>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge badge-info">
                                        <i class="fas fa-eye me-1"></i><?php echo number_format($video['view_count']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('d/m/Y H:i', strtotime($video['upload_date'])); ?></td>
                                <td>
                                    <a href="delete_video.php?id=<?php echo $video['id']; ?>" 
                                       class="btn btn-action btn-danger" 
                                       onclick="return confirm('¿Estás seguro?')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if ($total_pages > 1): ?>
            <div class="pagination">
                <nav aria-label="Page navigation">
                    <ul class="pagination">
                        <?php if ($page > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=<?php echo ($page - 1); ?>">
                                    <i class="fas fa-chevron-left"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                            <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endfor; ?>
                        
                        <?php if ($page < $total_pages): ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=<?php echo ($page + 1); ?>">
                                    <i class="fas fa-chevron-right"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
    // Funcionalidad de copiar URL
    document.querySelectorAll('.copy-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const input = this.previousElementSibling;
            input.select();
            document.execCommand('copy');
            
            const icon = this.querySelector('i');
            const originalClass = icon.className;
            icon.className = 'fas fa-check';
            
            setTimeout(() => {
                icon.className = originalClass;
            }, 2000);
        });
    });

    // Funcionalidad de selección múltiple
    const masterCheck = document.getElementById('masterCheck');
    const videoChecks = document.querySelectorAll('.video-check');
    const deleteSelected = document.getElementById('deleteSelected');
    const selectAllBtn = document.getElementById('selectAll');

    // Función para actualizar el estado del botón de eliminar
    function updateDeleteButton() {
        const checkedCount = document.querySelectorAll('.video-check:checked').length;
        deleteSelected.disabled = checkedCount === 0;
    }

    // Evento para el botón "Seleccionar Todo"
    selectAllBtn.addEventListener('click', function() {
        const newState = !masterCheck.checked;
        masterCheck.checked = newState;
        videoChecks.forEach(check => {
            check.checked = newState;
        });
        updateDeleteButton();
    });

    // Evento para el checkbox maestro
    masterCheck.addEventListener('change', function() {
        videoChecks.forEach(check => {
            check.checked = this.checked;
        });
        updateDeleteButton();
    });

    // Eventos para los checkboxes individuales
    videoChecks.forEach(check => {
        check.addEventListener('change', function() {
            const allChecked = Array.from(videoChecks).every(c => c.checked);
            const someChecked = Array.from(videoChecks).some(c => c.checked);
            masterCheck.checked = allChecked;
            masterCheck.indeterminate = someChecked && !allChecked;
            updateDeleteButton();
        });
    });

    // Evento para eliminar seleccionados
    deleteSelected.addEventListener('click', function() {
        if (confirm('¿Estás seguro de que quieres eliminar los videos seleccionados?')) {
            const selectedIds = Array.from(document.querySelectorAll('.video-check:checked'))
                                   .map(check => check.value);
            
            fetch('delete_videos.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ ids: selectedIds })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error al eliminar los videos');
                }
            });
        }
    });
    </script>
</body>
</html>