<?php
session_start();
include '../config.php';

if (!isset($_SESSION['admin_id'])) {
    header('Content-Type: application/json');
    die(json_encode(['success' => false, 'message' => 'No autorizado']));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $ids = $data['ids'] ?? [];
    
    if (empty($ids)) {
        die(json_encode(['success' => false, 'message' => 'No se seleccionaron videos']));
    }
    
    $ids = array_map('intval', $ids);
    $ids_string = implode(',', $ids);
    
    // Obtener información de los videos
    $query = "SELECT * FROM videos WHERE id IN ($ids_string)";
    $result = mysqli_query($conn, $query);
    
    while ($video = mysqli_fetch_assoc($result)) {
        // Eliminar archivo físico si existe
        if (!empty($video['filename'])) {
            $file_path = '../store/' . $video['filename'];
            if (file_exists($file_path)) {
                unlink($file_path);
            }
        }
    }
    
    // Eliminar las vistas asociadas primero
    $delete_views = "DELETE FROM video_views WHERE video_id IN ($ids_string)";
    mysqli_query($conn, $delete_views);
    
    // Eliminar registros de la base de datos
    $delete_query = "DELETE FROM videos WHERE id IN ($ids_string)";
    $success = mysqli_query($conn, $delete_query);
    
    echo json_encode(['success' => $success]);
    exit();
}

header('Content-Type: application/json');
echo json_encode(['success' => false, 'message' => 'Método no permitido']);
?>